/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.CollectionModel;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.rest.AbstractCatalogResource;
import org.geoserver.catalog.rest.CatalogFreemarkerHTMLFormat;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.DataFormat;
import org.geoserver.rest.format.ReflectiveHTMLFormat;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;

public class NamespaceResource
extends AbstractCatalogResource {
    public NamespaceResource(Context context, Request request, Response response, Catalog catalog) {
        super(context, request, response, NamespaceInfo.class, catalog);
    }

    @Override
    protected DataFormat createHTMLFormat(Request request, Response response) {
        return new NamespaceHTMLFormat(request, response, (Resource)this, this.catalog);
    }

    protected Object handleObjectGet() throws Exception {
        String ns = this.getAttribute("namespace");
        LOGGER.fine("GET namespace" + ns);
        return this.catalog.getNamespaceByPrefix(ns);
    }

    public boolean allowPost() {
        return this.getAttribute("namespace") == null;
    }

    protected String handleObjectPost(Object object) throws Exception {
        NamespaceInfo namespace = (NamespaceInfo)object;
        this.catalog.add(namespace);
        if (this.catalog.getWorkspaceByName(namespace.getPrefix()) == null) {
            WorkspaceInfo ws = this.catalog.getFactory().createWorkspace();
            ws.setName(namespace.getPrefix());
            this.catalog.add(ws);
        }
        LOGGER.info("POST namespace " + namespace);
        return namespace.getPrefix();
    }

    public boolean allowPut() {
        return this.getAttribute("namespace") != null;
    }

    protected void handleObjectPut(Object object) throws Exception {
        NamespaceInfo namespace = (NamespaceInfo)object;
        String ns = this.getAttribute("namespace");
        if ("default".equals(ns)) {
            this.catalog.setDefaultNamespace(namespace);
        } else {
            NamespaceInfo original = this.catalog.getNamespaceByPrefix(ns);
            if (namespace.getPrefix() != null && !namespace.getPrefix().equals(original.getPrefix())) {
                throw new RestletException("Can't change the prefix of a namespace.", Status.CLIENT_ERROR_FORBIDDEN);
            }
            new CatalogBuilder(this.catalog).updateNamespace(original, namespace);
            this.catalog.save(original);
        }
        LOGGER.info("PUT namespace " + namespace);
    }

    public boolean allowDelete() {
        return this.getAttribute("namespace") != null;
    }

    protected void handleObjectDelete() throws Exception {
        String namespace = this.getAttribute("namespace");
        NamespaceInfo ns = this.catalog.getNamespaceByPrefix(namespace);
        if (!this.catalog.getResourcesByNamespace(ns, ResourceInfo.class).isEmpty()) {
            throw new RestletException("Namespace not empty", Status.CLIENT_ERROR_UNAUTHORIZED);
        }
        this.catalog.remove(ns);
        LOGGER.info("DELETE namespace " + namespace);
    }

    @Override
    protected void configurePersister(XStreamPersister persister, DataFormat format) {
        persister.setCallback(new XStreamPersister.Callback(){

            protected void postEncodeNamespace(NamespaceInfo ns, HierarchicalStreamWriter writer, MarshallingContext context) {
                writer.startNode("featureTypes");
                NamespaceResource.this.encodeCollectionLink("/workspaces/" + ns.getPrefix() + "/featuretypes", writer);
                writer.endNode();
            }
        });
    }

    static class NamespaceHTMLFormat
    extends CatalogFreemarkerHTMLFormat {
        Catalog catalog;

        public NamespaceHTMLFormat(Request request, Response response, Resource resource, Catalog catalog) {
            super(NamespaceInfo.class, request, response, resource);
            this.catalog = catalog;
        }

        @Override
        protected Configuration createConfiguration(Object data, Class clazz) {
            Configuration cfg = super.createConfiguration(data, clazz);
            cfg.setObjectWrapper((ObjectWrapper)new ReflectiveHTMLFormat.ObjectToMapWrapper<NamespaceInfo>(NamespaceInfo.class){

                protected void wrapInternal(Map properties, SimpleHash model, NamespaceInfo object) {
                    List stores = NamespaceHTMLFormat.this.catalog.getResourcesByNamespace(object, ResourceInfo.class);
                    properties.put("resources", new CollectionModel((Collection)stores, (BeansWrapper)new ReflectiveHTMLFormat.ObjectToMapWrapper((ReflectiveHTMLFormat)NamespaceHTMLFormat.this, ResourceInfo.class)));
                    properties.put("isDefault", object.equals(NamespaceHTMLFormat.this.catalog.getDefaultNamespace()));
                }
            });
            return cfg;
        }
    }
}

