/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.rest.AbstractCatalogFinder;
import org.geoserver.catalog.rest.LayerGroupListResource;
import org.geoserver.catalog.rest.LayerGroupResource;
import org.geoserver.rest.RestletException;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;

public class LayerGroupFinder
extends AbstractCatalogFinder {
    public LayerGroupFinder(Catalog catalog) {
        super(catalog);
    }

    public Resource findTarget(Request request, Response response) {
        String ws = this.getAttribute(request, "workspace");
        String lg = this.getAttribute(request, "layergroup");
        if (ws != null && this.catalog.getWorkspaceByName(ws) == null) {
            throw new RestletException("No such workspace: " + ws, Status.CLIENT_ERROR_NOT_FOUND);
        }
        if (lg != null) {
            if (ws != null && this.catalog.getLayerGroupByName(ws, lg) == null) {
                throw new RestletException(String.format("No such layer group %s in workspace %s", lg, ws), Status.CLIENT_ERROR_NOT_FOUND);
            }
            if (ws == null && this.catalog.getLayerGroupByName(lg) == null) {
                throw new RestletException("No such layer group " + lg, Status.CLIENT_ERROR_NOT_FOUND);
            }
        }
        if (lg == null && request.getMethod() == Method.GET) {
            return new LayerGroupListResource(this.getContext(), request, response, this.catalog);
        }
        return new LayerGroupResource(this.getContext(), request, response, this.catalog);
    }
}

