/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.rest.AbstractCatalogResource;
import org.geoserver.catalog.rest.ResourceHTMLFormat;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.DataFormat;
import org.geotools.data.DataAccess;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureSource;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;

public class FeatureTypeResource
extends AbstractCatalogResource {
    public FeatureTypeResource(Context context, Request request, Response response, Catalog catalog) {
        super(context, request, response, FeatureTypeInfo.class, catalog);
    }

    @Override
    protected DataFormat createHTMLFormat(Request request, Response response) {
        return new ResourceHTMLFormat(FeatureTypeInfo.class, request, response, (Resource)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object handleObjectGet() {
        String workspace = this.getAttribute("workspace");
        String datastore = this.getAttribute("datastore");
        String featureType = this.getAttribute("featuretype");
        if (datastore == null) {
            LOGGER.fine("GET feature type" + workspace + "," + featureType);
            NamespaceInfo ns = this.catalog.getNamespaceByPrefix(workspace);
            if (ns != null) {
                return this.catalog.getFeatureTypeByName(ns, featureType);
            }
            String message = "No feature found in workspace '" + workspace + "' with name '" + featureType + "'";
            throw new RestletException(message, Status.CLIENT_ERROR_NOT_FOUND);
        }
        LOGGER.fine("GET feature type" + datastore + "," + featureType);
        DataStoreInfo dsInfo = this.catalog.getDataStoreByName(workspace, datastore);
        return this.catalog.getFeatureTypeByDataStore(dsInfo, featureType);
    }

    public boolean allowPost() {
        return this.getAttribute("featuretype") == null;
    }

    protected String handleObjectPost(Object object) throws Exception {
        NamespaceInfo ns;
        String workspace = this.getAttribute("workspace");
        String dataStore = this.getAttribute("datastore");
        FeatureTypeInfo featureType = (FeatureTypeInfo)object;
        if (featureType.getStore() != null) {
            if (!dataStore.equals(featureType.getStore().getName())) {
                throw new RestletException("Expected datastore " + dataStore + " but client specified " + featureType.getStore().getName(), Status.CLIENT_ERROR_FORBIDDEN);
            }
        } else {
            featureType.setStore((StoreInfo)this.catalog.getDataStoreByName(workspace, dataStore));
        }
        if (featureType.getNamespace() != null) {
            if (!workspace.equals(featureType.getNamespace().getPrefix())) {
                throw new RestletException("Expected workspace " + workspace + " but client specified " + featureType.getNamespace().getPrefix(), Status.CLIENT_ERROR_FORBIDDEN);
            }
        } else {
            featureType.setNamespace(this.catalog.getNamespaceByPrefix(workspace));
        }
        featureType.setEnabled(true);
        DataStoreInfo ds = this.catalog.getDataStoreByName(workspace, dataStore);
        DataAccess gtda = ds.getDataStore(null);
        if (gtda instanceof DataStore) {
            MetadataMap mdm;
            boolean virtual;
            String typeName = featureType.getName();
            if (featureType.getNativeName() != null) {
                typeName = featureType.getNativeName();
            }
            boolean typeExists = false;
            DataStore gtds = (DataStore)gtda;
            for (String name : gtds.getTypeNames()) {
                if (!name.equals(typeName)) continue;
                typeExists = true;
                break;
            }
            boolean bl = virtual = (mdm = featureType.getMetadata()) != null && mdm.containsKey((Object)"JDBC_VIRTUAL_TABLE");
            if (!virtual && !typeExists) {
                gtds.createSchema((FeatureType)this.buildFeatureType(featureType));
                featureType.getAttributes().clear();
                List<String> typeNames = Arrays.asList(gtds.getTypeNames());
                if (!typeNames.contains(typeName) && typeNames.contains(typeName.toUpperCase())) {
                    featureType.setNativeName(featureType.getName().toLowerCase());
                }
            }
        }
        CatalogBuilder cb = new CatalogBuilder(this.catalog);
        cb.initFeatureType(featureType);
        try {
            FeatureSource featureSource = gtda.getFeatureSource((Name)new NameImpl(featureType.getNativeName()));
            if (featureSource != null) {
                cb.setupMetadata(featureType, featureSource);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unable to fill in metadata from underlying feature source", e);
        }
        if (featureType.getStore() == null) {
            featureType.setStore((StoreInfo)ds);
        }
        if ((ns = featureType.getNamespace()) != null && !ns.getPrefix().equals(workspace)) {
            LOGGER.warning("Namespace: " + ns.getPrefix() + " does not match workspace: " + workspace + ", overriding.");
            ns = null;
        }
        if (ns == null) {
            ns = this.catalog.getNamespaceByPrefix(workspace);
            featureType.setNamespace(ns);
        }
        featureType.setEnabled(true);
        this.catalog.add((ResourceInfo)featureType);
        this.catalog.add(new CatalogBuilder(this.catalog).buildLayer(featureType));
        LOGGER.info("POST feature type" + dataStore + "," + featureType.getName());
        return featureType.getName();
    }

    SimpleFeatureType buildFeatureType(FeatureTypeInfo fti) {
        if (fti.getName() == null) {
            throw new RestletException("Trying to create new feature type inside the store, but no feature type name was specified", Status.CLIENT_ERROR_BAD_REQUEST);
        }
        if (fti.getAttributes() == null || fti.getAttributes() == null) {
            throw new RestletException("Trying to create new feature type inside the store, but no attributes were specified", Status.CLIENT_ERROR_BAD_REQUEST);
        }
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        if (fti.getNativeName() != null) {
            builder.setName(fti.getNativeName());
        } else {
            builder.setName(fti.getName());
        }
        if (fti.getNativeCRS() != null) {
            builder.setCRS(fti.getNativeCRS());
        } else if (fti.getCRS() != null) {
            builder.setCRS(fti.getCRS());
        } else if (fti.getSRS() != null) {
            builder.setSRS(fti.getSRS());
        }
        for (AttributeTypeInfo ati : fti.getAttributes()) {
            if (ati.getLength() != null && ati.getLength() > 0) {
                builder.length(ati.getLength().intValue());
            }
            builder.nillable(ati.isNillable());
            builder.add(ati.getName(), ati.getBinding());
        }
        return builder.buildFeatureType();
    }

    public boolean allowPut() {
        return this.getAttribute("featuretype") != null;
    }

    protected void handleObjectPut(Object object) throws Exception {
        FeatureTypeInfo ft = (FeatureTypeInfo)object;
        String workspace = this.getAttribute("workspace");
        String datastore = this.getAttribute("datastore");
        String featuretype = this.getAttribute("featuretype");
        DataStoreInfo ds = this.catalog.getDataStoreByName(workspace, datastore);
        FeatureTypeInfo original = this.catalog.getFeatureTypeByDataStore(ds, featuretype);
        new CatalogBuilder(this.catalog).updateFeatureType(original, ft);
        this.calculateOptionalFields((ResourceInfo)ft, (ResourceInfo)original);
        this.catalog.save((ResourceInfo)original);
        this.clear(original);
        LOGGER.info("PUT feature type" + datastore + "," + featuretype);
    }

    public boolean allowDelete() {
        return this.getAttribute("featuretype") != null;
    }

    public void handleObjectDelete() throws Exception {
        String workspace = this.getAttribute("workspace");
        String datastore = this.getAttribute("datastore");
        String featuretype = this.getAttribute("featuretype");
        boolean recurse = (Boolean)this.getQueryStringValue("recurse", Boolean.class, false);
        DataStoreInfo ds = this.catalog.getDataStoreByName(workspace, datastore);
        FeatureTypeInfo ft = this.catalog.getFeatureTypeByDataStore(ds, featuretype);
        List layers = this.catalog.getLayers((ResourceInfo)ft);
        if (recurse) {
            for (LayerInfo l : layers) {
                this.catalog.remove(l);
                LOGGER.info("DELETE layer " + l.getName());
            }
        } else if (!layers.isEmpty()) {
            throw new RestletException("feature type referenced by layer(s)", Status.CLIENT_ERROR_FORBIDDEN);
        }
        this.catalog.remove((ResourceInfo)ft);
        this.clear(ft);
        LOGGER.info("DELETE feature type" + datastore + "," + featuretype);
    }

    void clear(FeatureTypeInfo info) {
        this.catalog.getResourcePool().clear(info);
        this.catalog.getResourcePool().clear(info.getStore());
    }

    @Override
    protected void configurePersister(XStreamPersister persister, DataFormat format) {
        persister.setHideFeatureTypeAttributes();
        persister.setCallback(new XStreamPersister.Callback(){

            protected void postEncodeReference(Object obj, String ref, String prefix, HierarchicalStreamWriter writer, MarshallingContext context) {
                if (obj instanceof NamespaceInfo) {
                    NamespaceInfo ns = (NamespaceInfo)obj;
                    FeatureTypeResource.this.encodeLink("/namespaces/" + FeatureTypeResource.this.encode(ns.getPrefix()), writer);
                }
                if (obj instanceof DataStoreInfo) {
                    DataStoreInfo ds = (DataStoreInfo)obj;
                    FeatureTypeResource.this.encodeLink("/workspaces/" + FeatureTypeResource.this.encode(ds.getWorkspace().getName()) + "/datastores/" + FeatureTypeResource.this.encode(ds.getName()), writer);
                }
            }

            protected void postEncodeFeatureType(FeatureTypeInfo ft, HierarchicalStreamWriter writer, MarshallingContext context) {
                try {
                    writer.startNode("attributes");
                    context.convertAnother((Object)ft.attributes());
                    writer.endNode();
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not get native attributes", e);
                }
            }
        });
    }
}

