/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.rest.AbstractCatalogFinder;
import org.geoserver.catalog.rest.AvailableFeatureTypeResource;
import org.geoserver.catalog.rest.FeatureTypeListResource;
import org.geoserver.catalog.rest.FeatureTypeResource;
import org.geoserver.rest.RestletException;
import org.restlet.data.Form;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;

public class FeatureTypeFinder
extends AbstractCatalogFinder {
    protected FeatureTypeFinder(Catalog catalog) {
        super(catalog);
    }

    public Resource findTarget(Request request, Response response) {
        String ws = this.getAttribute(request, "workspace");
        String ds = this.getAttribute(request, "datastore");
        String ft = this.getAttribute(request, "featuretype");
        if (ws != null && this.catalog.getWorkspaceByName(ws) == null) {
            throw new RestletException("No such workspace: " + ws, Status.CLIENT_ERROR_NOT_FOUND);
        }
        if (ds != null && this.catalog.getDataStoreByName(ws, ds) == null) {
            throw new RestletException("No such datastore: " + ws + "," + ds, Status.CLIENT_ERROR_NOT_FOUND);
        }
        if (ft != null) {
            if (ds != null && this.catalog.getFeatureTypeByDataStore(this.catalog.getDataStoreByName(ws, ds), ft) == null) {
                throw new RestletException("No such feature type: " + ws + "," + ds + "," + ft, Status.CLIENT_ERROR_NOT_FOUND);
            }
            NamespaceInfo ns = this.catalog.getNamespaceByPrefix(ws);
            if (ns == null || this.catalog.getFeatureTypeByName(ns, ft) == null) {
                throw new RestletException("No such feature type: " + ws + "," + ft, Status.CLIENT_ERROR_NOT_FOUND);
            }
        } else {
            Form form = request.getResourceRef().getQueryAsForm();
            String list = form.getFirstValue("list");
            if ("available".equalsIgnoreCase(list) || "available_with_geom".equalsIgnoreCase(list)) {
                return new AvailableFeatureTypeResource(null, request, response, this.catalog);
            }
            if (request.getMethod() == Method.GET) {
                return new FeatureTypeListResource(this.getContext(), request, response, this.catalog);
            }
        }
        return new FeatureTypeResource(null, request, response, this.catalog);
    }
}

