/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.CollectionModel;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.rest.AbstractCatalogResource;
import org.geoserver.catalog.rest.CatalogFreemarkerHTMLFormat;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.DataFormat;
import org.geoserver.rest.format.ReflectiveHTMLFormat;
import org.geotools.data.DataAccessFactory;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;
import org.vfny.geoserver.util.DataStoreUtils;

public class DataStoreResource
extends AbstractCatalogResource {
    public DataStoreResource(Context context, Request request, Response response, Catalog catalog) {
        super(context, request, response, DataStoreInfo.class, catalog);
    }

    @Override
    protected DataFormat createHTMLFormat(Request request, Response response) {
        return new DataStoreHTMLFormat(request, response, (Resource)this, this.catalog);
    }

    protected Object handleObjectGet() {
        String ws = this.getAttribute("workspace");
        String ds = this.getAttribute("datastore");
        WorkspaceInfo wsInfo = this.catalog.getWorkspaceByName(ws);
        LOGGER.fine("GET data store " + ws + "," + ds);
        return this.catalog.getDataStoreByName(wsInfo, ds);
    }

    public boolean allowPost() {
        return this.getAttribute("datastore") == null;
    }

    protected String handleObjectPost(Object object) throws Exception {
        DataStoreInfo ds;
        block8: {
            String workspace = this.getAttribute("workspace");
            ds = (DataStoreInfo)object;
            if (ds.getWorkspace() != null) {
                WorkspaceInfo ws = ds.getWorkspace();
                if (!workspace.equals(ws.getName())) {
                    throw new RestletException("Expected workspace " + workspace + " but client specified " + ws.getName(), Status.CLIENT_ERROR_FORBIDDEN);
                }
            } else {
                ds.setWorkspace(this.catalog.getWorkspaceByName(workspace));
            }
            ds.setEnabled(true);
            Map params = ds.getConnectionParameters();
            if (!ds.getConnectionParameters().containsKey("namespace")) {
                WorkspaceInfo ws = ds.getWorkspace();
                NamespaceInfo ns = this.catalog.getNamespaceByPrefix(ws.getName());
                if (ns == null) {
                    ns = this.catalog.getDefaultNamespace();
                }
                if (ns != null) {
                    ds.getConnectionParameters().put("namespace", ns.getURI());
                }
            }
            try {
                DataAccessFactory factory = DataStoreUtils.aquireFactory((Map)ds.getConnectionParameters());
                ds.setType(factory.getDisplayName());
            }
            catch (Exception e) {
                LOGGER.warning("Unable to determine datastore type from connection parameters");
                if (!LOGGER.isLoggable(Level.FINE)) break block8;
                LOGGER.log(Level.FINE, "", e);
            }
        }
        this.catalog.add((StoreInfo)((DataStoreInfo)object));
        LOGGER.info("POST data store " + ds.getName());
        return ds.getName();
    }

    public boolean allowPut() {
        return this.getAttribute("datastore") != null;
    }

    protected void handleObjectPut(Object object) throws Exception {
        String workspace = this.getAttribute("workspace");
        String datastore = this.getAttribute("datastore");
        DataStoreInfo ds = (DataStoreInfo)object;
        DataStoreInfo original = this.catalog.getDataStoreByName(workspace, datastore);
        if (ds.getName() != null && !ds.getName().equals(original.getName())) {
            throw new RestletException("Can't change name of data store.", Status.CLIENT_ERROR_FORBIDDEN);
        }
        if (ds.getWorkspace() != null && !ds.getWorkspace().equals(original.getWorkspace())) {
            throw new RestletException("Can't change workspace of data store.", Status.CLIENT_ERROR_FORBIDDEN);
        }
        new CatalogBuilder(this.catalog).updateDataStore(original, ds);
        this.catalog.save((StoreInfo)original);
        this.clear(original);
        LOGGER.info("PUT data store " + workspace + "," + datastore);
    }

    public boolean allowDelete() {
        return this.getAttribute("datastore") != null;
    }

    protected void handleObjectDelete() throws Exception {
        String workspace = this.getAttribute("workspace");
        String datastore = this.getAttribute("datastore");
        boolean recurse = (Boolean)this.getQueryStringValue("recurse", Boolean.class, false);
        DataStoreInfo ds = this.catalog.getDataStoreByName(workspace, datastore);
        if (!recurse) {
            if (!this.catalog.getFeatureTypesByDataStore(ds).isEmpty()) {
                throw new RestletException("datastore not empty", Status.CLIENT_ERROR_FORBIDDEN);
            }
            this.catalog.remove((StoreInfo)ds);
        } else {
            new CascadeDeleteVisitor(this.catalog).visit(ds);
        }
        this.clear(ds);
        LOGGER.info("DELETE data store " + workspace + "," + datastore);
    }

    void clear(DataStoreInfo info) {
        this.catalog.getResourcePool().clear(info);
    }

    @Override
    protected void configurePersister(XStreamPersister persister, DataFormat format) {
        persister.setCallback(new XStreamPersister.Callback(){

            protected void postEncodeDataStore(DataStoreInfo ds, HierarchicalStreamWriter writer, MarshallingContext context) {
                writer.startNode("featureTypes");
                DataStoreResource.this.encodeCollectionLink("featuretypes", writer);
                writer.endNode();
            }

            protected void postEncodeReference(Object obj, String ref, String prefix, HierarchicalStreamWriter writer, MarshallingContext context) {
                if (obj instanceof WorkspaceInfo) {
                    DataStoreResource.this.encodeLink("/workspaces/" + DataStoreResource.this.encode(ref), writer);
                }
            }
        });
    }

    static class DataStoreHTMLFormat
    extends CatalogFreemarkerHTMLFormat {
        Catalog catalog;

        public DataStoreHTMLFormat(Request request, Response response, Resource resource, Catalog catalog) {
            super(DataStoreInfo.class, request, response, resource);
            this.catalog = catalog;
        }

        @Override
        protected Configuration createConfiguration(Object data, Class clazz) {
            Configuration cfg = super.createConfiguration(data, clazz);
            cfg.setObjectWrapper((ObjectWrapper)new ReflectiveHTMLFormat.ObjectToMapWrapper<DataStoreInfo>(DataStoreInfo.class){

                protected void wrapInternal(Map properties, SimpleHash model, DataStoreInfo object) {
                    List featureTypes = DataStoreHTMLFormat.this.catalog.getFeatureTypesByDataStore(object);
                    properties.put("featureTypes", new CollectionModel((Collection)featureTypes, (BeansWrapper)new ReflectiveHTMLFormat.ObjectToMapWrapper((ReflectiveHTMLFormat)DataStoreHTMLFormat.this, FeatureTypeInfo.class)));
                }
            });
            return cfg;
        }
    }
}

