/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.rest.AbstractCatalogResource;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.ReflectiveXMLFormat;
import org.geotools.data.ows.Layer;
import org.geotools.data.wms.WebMapServer;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

public class AvailableWMSLayerResource
extends AbstractCatalogResource {
    public AvailableWMSLayerResource(Context context, Request request, Response response, Catalog catalog) {
        super(context, request, response, FeatureTypeInfo.class, catalog);
    }

    protected Object handleObjectGet() {
        String wmsstore;
        String workspace = (String)this.getRequest().getAttributes().get("workspace");
        WMSStoreInfo info = (WMSStoreInfo)this.catalog.getStoreByName(workspace, wmsstore = (String)this.getRequest().getAttributes().get("wmsstore"), WMSStoreInfo.class);
        if (info == null) {
            throw new RestletException("No such WMS store: " + wmsstore, Status.CLIENT_ERROR_NOT_FOUND);
        }
        ArrayList<String> available = new ArrayList<String>();
        try {
            WebMapServer ds = info.getWebMapServer(null);
            for (Layer layer : ds.getCapabilities().getLayerList()) {
                WMSLayerInfo wIinfo;
                if (layer.getName() == null || "".equals(layer.getName()) || (wIinfo = (WMSLayerInfo)this.catalog.getResourceByStore((StoreInfo)info, layer.getName(), WMSLayerInfo.class)) != null) continue;
                available.add(layer.getName());
            }
        }
        catch (IOException e) {
            throw new RestletException("Could not load wms store: " + wmsstore, Status.SERVER_ERROR_INTERNAL, (Throwable)e);
        }
        return available;
    }

    @Override
    protected ReflectiveXMLFormat createXMLFormat(Request request, Response response) {
        return new ReflectiveXMLFormat(){

            protected void write(Object data, OutputStream output) throws IOException {
                XStream xstream = new XStream();
                xstream.alias("wmsLayerName", String.class);
                xstream.toXML(data, output);
            }
        };
    }

    public boolean allowPost() {
        return false;
    }

    protected String handleObjectPost(Object object) {
        return null;
    }

    protected void handleObjectPut(Object object) {
    }
}

