/*
 * Decompiled with CFR 0.152.
 */
package simple.util.schedule;

final class Registry {
    private Entry root;

    public Registry() {
        this.init();
    }

    private void init() {
        this.root = new Entry();
        this.root.wait = Long.MAX_VALUE;
        this.root.prev = this.root;
        this.root.next = null;
    }

    public synchronized void sleeping(long timeout) {
        Thread thread = Thread.currentThread();
        Entry entry = new Entry();
        entry.thread = thread;
        entry.wait = timeout;
        this.link(entry, this.root);
    }

    private void link(Entry entry, Entry head) {
        while (head.next != entry && head.prev != entry) {
            if (head.wait <= entry.wait) {
                head.prev.next = entry;
                entry.prev = head.prev;
                head.prev = entry;
                entry.next = head;
                continue;
            }
            if (head.next == null) {
                head.next = entry;
                entry.prev = head;
                continue;
            }
            head = head.next;
        }
    }

    private void unlink(Entry entry) {
        entry.prev.next = entry.next;
        if (entry.next != null) {
            entry.next.prev = entry.prev;
        }
    }

    public synchronized void remove() {
        Thread thread = Thread.currentThread();
        Entry entry = this.root.next;
        while (entry != null) {
            if (thread == entry.thread) {
                Thread.interrupted();
                this.unlink(entry);
                entry = null;
                continue;
            }
            entry = entry.next;
        }
    }

    public synchronized void interrupt(long wait) {
        Entry entry = this.root.next;
        if (entry != null && entry.wait > wait) {
            entry.thread.interrupt();
        }
    }

    private class Entry {
        public Thread thread;
        public long wait;
        public Entry next;
        public Entry prev;

        private Entry() {
        }
    }
}

