/*
 * Decompiled with CFR 0.152.
 */
package simple.util.process;

import java.util.Observable;
import simple.util.MessageQueue;
import simple.util.process.Daemon;
import simple.util.process.ProcessPermission;

public final class ProcessQueue
extends Observable {
    private static ProcessQueue engine = new ProcessQueue(20);
    private MessageQueue ready = new MessageQueue();
    private int capacity;

    public static synchronized ProcessQueue getInstance() {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(new ProcessPermission("execute"));
        }
        return engine;
    }

    private ProcessQueue(int size) {
        this.increase(size);
    }

    public void execute(Runnable target) throws InterruptedException {
        Daemon daemon = (Daemon)this.ready.dequeue();
        daemon.process(target);
    }

    public synchronized void resize(int size) {
        if (this.capacity < size) {
            this.increase(size);
        } else if (size < this.capacity) {
            this.reduce(size);
        }
        this.notifyObservers();
    }

    public synchronized int capacity() {
        return this.capacity;
    }

    private synchronized void increase(int size) {
        while (this.capacity < size) {
            new Daemon(this.ready);
            ++this.capacity;
        }
    }

    private synchronized void reduce(int size) {
        while (size < this.capacity) {
            Daemon daemon = null;
            try {
                daemon = (Daemon)this.ready.dequeue();
            }
            catch (InterruptedException e) {
                continue;
            }
            daemon.kill();
            --this.capacity;
        }
    }

    public synchronized void stop() {
        this.resize(0);
    }
}

