/*
 * Decompiled with CFR 0.152.
 */
package simple.util.lease;

import simple.util.lease.Cleaner;
import simple.util.lease.Contract;
import simple.util.lease.LeaseException;
import simple.util.lease.LeaseHandler;
import simple.util.lease.Processor;

class DefaultHandler
implements LeaseHandler {
    private Processor handler;

    public DefaultHandler(Cleaner cleaner) {
        this.handler = new Processor(cleaner);
    }

    public void lease(String name, long wait) {
        this.handler.lease(new Entry(name, wait));
    }

    public void renew(String name, long wait) throws LeaseException {
        this.handler.update(new Entry(name, wait));
    }

    public void cancel(String name) throws LeaseException {
        this.handler.update(new Entry(name));
    }

    public long getExpiry(String name) throws LeaseException {
        return this.handler.lookup(name).getExpiry();
    }

    private class Entry
    implements Contract {
        private String name;
        private long expiry;

        public Entry(String name) {
            this.expiry = System.currentTimeMillis();
            this.name = name;
        }

        public Entry(String name, long wait) {
            this.expiry = wait + System.currentTimeMillis();
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public long getExpiry() {
            return this.expiry - System.currentTimeMillis();
        }

        public boolean equals(Object value) {
            if (value != null) {
                return value.equals(this.name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

