/*
 * Decompiled with CFR 0.152.
 */
package simple.util;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import simple.util.PropertyLoader;
import simple.util.parse.ParseBuffer;
import simple.util.parse.Parser;
import simple.util.parse.PropertyBuffer;

final class PlainLoader
extends Parser
implements PropertyLoader {
    private PropertyBuffer value = new PropertyBuffer();
    private ParseBuffer text;
    private ParseBuffer name = new ParseBuffer();
    private Properties table;

    public PlainLoader(Properties table) {
        this.text = new ParseBuffer();
        this.table = table;
    }

    public void load(InputStream source) throws Exception {
        this.load(source, "utf-8");
    }

    public void load(InputStream source, String charset) throws Exception {
        this.load(new InputStreamReader(source, charset));
    }

    private void load(Reader source) throws Exception {
        int num;
        char[] buf = new char[64];
        while ((num = source.read(buf)) >= 0) {
            this.text.append(buf, 0, num);
        }
        this.parse(this.text);
    }

    private void parse(ParseBuffer text) {
        this.parse(text.toString());
    }

    protected void init() {
        this.table.clear();
        this.name.clear();
        this.value.clear();
        this.text.clear();
    }

    protected void parse() {
        while (this.off < this.count) {
            char ch = this.buf[this.off];
            if (this.comment(ch)) {
                this.line();
                continue;
            }
            this.entry();
        }
    }

    private void line() {
        while (this.off < this.count) {
            char ch;
            if (this.terminal(ch = this.buf[this.off++])) break;
        }
    }

    private void entry() {
        this.name();
        if (this.skip("=")) {
            this.value();
        } else if (this.skip(":")) {
            this.value();
        }
        this.insert();
    }

    private void insert() {
        if (this.value.length() > 0) {
            this.insert(this.name, this.value);
        }
        this.name.clear();
        this.value.clear();
    }

    private void insert(ParseBuffer name, ParseBuffer value) {
        this.insert(name.toString(), value.toString());
    }

    private void insert(String name, String value) {
        this.table.put(name.trim(), value.trim());
    }

    private void name() {
        while (this.off < this.count) {
            char ch;
            if (this.terminal(ch = this.buf[this.off++])) break;
            if (this.equal(ch)) {
                --this.off;
                break;
            }
            this.name.append(ch);
        }
    }

    private void value() {
        while (this.off < this.count) {
            char ch;
            if (this.terminal(ch = this.buf[this.off++])) break;
            this.value.append(ch);
        }
    }

    private boolean terminal(char ch) {
        return ch == '\r' || ch == '\n';
    }

    private boolean comment(char ch) {
        return ch == '#' || ch == '!';
    }

    private boolean equal(char ch) {
        return ch == '=' || ch == ':';
    }
}

