/*
 * Decompiled with CFR 0.152.
 */
package simple.http.session;

import simple.http.State;
import simple.http.session.Delegate;
import simple.http.session.Identifier;
import simple.http.session.IdentifierFactory;
import simple.http.session.Maintainer;
import simple.http.session.MaintainerFactory;
import simple.http.session.Module;
import simple.http.session.Registry;
import simple.http.session.Session;
import simple.http.session.Store;
import simple.util.lease.Lease;
import simple.util.lease.LeaseException;
import simple.util.net.Cookie;

final class Activator {
    private Registry registry;
    private Maintainer manager = MaintainerFactory.getInstance();
    private Identifier lookup = IdentifierFactory.getInstance();

    public Activator() {
        this(new Registry());
    }

    private Activator(Registry registry) {
        this.registry = registry;
    }

    public Session activate(State state) {
        return this.activate(state, null);
    }

    public Session activate(State state, Object data) {
        return this.activate(this.lookup.getIdentity(state), data);
    }

    private Session activate(Cookie cookie, Object data) {
        try {
            Module module = this.retrieve(cookie, data);
            return new Delegate(module, cookie);
        }
        catch (LeaseException e) {
            return null;
        }
    }

    private Module retrieve(Cookie cookie, Object data) throws LeaseException {
        Module module = this.registry.lookup(cookie, data);
        try {
            Lease lease = module.getLease();
            Store store = module.getStore();
            this.manager.renew(lease, store);
        }
        catch (LeaseException e) {
            throw new LeaseException("Lease expired");
        }
        return module;
    }
}

