/*
 * Decompiled with CFR 0.152.
 */
package simple.http.serve;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import simple.http.serve.Context;
import simple.http.serve.IndexedContent;

final class StreamContent
extends IndexedContent {
    public StreamContent(Context context, String target) {
        super(context, target);
    }

    public void write(OutputStream out) throws IOException {
        int size = this.getLength();
        if (size > 0) {
            this.write(out, size);
        }
    }

    private void write(OutputStream out, int size) throws IOException {
        InputStream in = this.getInputStream();
        if (size > 0) {
            this.write(out, in, size);
        }
        in.close();
    }

    private void write(OutputStream out, InputStream in, int size) throws IOException {
        int len;
        byte[] swap = new byte[2048];
        while ((len = in.read(swap)) >= 0) {
            out.write(swap, 0, len);
        }
    }
}

