/*
 * Decompiled with CFR 0.152.
 */
package simple.http.serve;

import java.io.File;
import java.util.Locale;
import simple.http.serve.Index;
import simple.http.serve.Indexer;
import simple.util.net.Path;
import simple.util.net.URI;
import simple.util.parse.URIParser;

final class FileIndex
implements Index {
    private Indexer indexer;
    private Path path;
    private File file;
    private String type;
    private Locale locale;
    private URI target;

    public FileIndex(Indexer indexer, String target) {
        this(indexer, new URIParser(target));
    }

    public FileIndex(Indexer indexer, URI target) {
        this.indexer = indexer;
        this.target = target;
    }

    public String getContentType() {
        if (this.type == null) {
            this.type = this.getContentType(this.target);
        }
        return this.type;
    }

    public String getContentType(URI target) {
        return this.indexer.getContentType(target);
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = this.getLocale(this.target);
        }
        return this.locale;
    }

    public Locale getLocale(URI target) {
        return this.indexer.getLocale(target);
    }

    public File getFile() {
        if (this.file == null) {
            this.file = this.getFile(this.target);
        }
        return this.file;
    }

    public File getFile(URI target) {
        return this.indexer.getFile(target);
    }

    public Path getPath() {
        if (this.path == null) {
            this.path = this.getPath(this.target);
        }
        return this.path;
    }

    public Path getPath(URI target) {
        return this.indexer.getPath(target);
    }

    public String getRealPath() {
        return this.getFile().getAbsolutePath();
    }

    public File getDirectory() {
        return this.getFile().getParentFile();
    }

    public String getRequestPath() {
        return this.getPath().getPath();
    }

    public String getName() {
        return this.getPath().getName();
    }
}

