/*
 * Decompiled with CFR 0.152.
 */
package simple.http;

import java.io.IOException;
import java.io.InputStream;
import simple.http.InputMonitor;

abstract class MonitoredInputStream
extends InputStream {
    protected InputMonitor mon;
    protected InputStream in;
    protected boolean open = true;

    protected MonitoredInputStream(InputStream in, InputMonitor mon) {
        this.mon = mon;
        this.in = in;
    }

    public synchronized int read() throws IOException {
        this.ensureOpen();
        try {
            int octet = this.readByte();
            if (octet < 0) {
                this.mon.notifyFinished(this.in);
            }
            return octet;
        }
        catch (IOException e) {
            this.mon.notifyError(this.in);
            this.destroy();
            return -1;
        }
    }

    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        this.ensureOpen();
        try {
            int num = this.readBytes(buf, off, len);
            if (num < 0) {
                this.mon.notifyFinished(this.in);
            }
            return num;
        }
        catch (IOException e) {
            this.mon.notifyError(this.in);
            this.destroy();
            return -1;
        }
    }

    public synchronized long skip(long amount) throws IOException {
        this.ensureOpen();
        try {
            return this.skipBytes(amount);
        }
        catch (IOException e) {
            this.mon.notifyError(this.in);
            this.destroy();
            return 0L;
        }
    }

    public synchronized int available() throws IOException {
        this.ensureOpen();
        try {
            return this.readyBytes();
        }
        catch (IOException e) {
            this.mon.notifyError(this.in);
            this.destroy();
            return 0;
        }
    }

    protected void ensureOpen() throws IOException {
        if (!this.open) {
            throw new IOException("Stream closed");
        }
    }

    protected void destroy() throws IOException {
        try {
            throw new IOException("Broken pipe");
        }
        catch (Throwable throwable) {
            this.open = false;
            throw throwable;
        }
    }

    public synchronized void close() throws IOException {
        try {
            try {
                if (this.open) {
                    this.doClose();
                }
            }
            catch (IOException e) {
                this.mon.notifyError(this.in);
            }
        }
        finally {
            this.open = false;
        }
    }

    protected abstract int readByte() throws IOException;

    protected abstract int readBytes(byte[] var1, int var2, int var3) throws IOException;

    protected abstract int readyBytes() throws IOException;

    protected abstract long skipBytes(long var1) throws IOException;

    protected abstract void doClose() throws IOException;
}

