/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.ext.simple;

import com.noelios.restlet.http.HttpServerCall;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.restlet.Server;
import org.restlet.data.Parameter;
import org.restlet.data.Response;
import org.restlet.util.Series;
import simple.http.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCall
extends HttpServerCall {
    private Request request;
    private simple.http.Response response;
    private boolean requestHeadersAdded;

    SimpleCall(Server server, Request request, simple.http.Response response, boolean confidential) {
        super(server);
        this.request = request;
        this.response = response;
        this.setConfidential(confidential);
        this.requestHeadersAdded = false;
    }

    public String getClientAddress() {
        return this.request.getInetAddress().getHostAddress();
    }

    public int getClientPort() {
        Socket sock = (Socket)this.request.getAttribute("org.restlet.ext.simple.socket");
        return sock != null ? sock.getPort() : -1;
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public ReadableByteChannel getRequestChannel() {
        return null;
    }

    public Series<Parameter> getRequestHeaders() {
        Series result = super.getRequestHeaders();
        if (!this.requestHeadersAdded) {
            int headerCount = this.request.headerCount();
            for (int i = 0; i < headerCount; ++i) {
                result.add((Object)new Parameter(this.request.getName(i), this.request.getValue(i)));
            }
            this.requestHeadersAdded = true;
        }
        return result;
    }

    public InputStream getRequestStream() {
        try {
            return this.request.getInputStream();
        }
        catch (IOException ex) {
            return null;
        }
    }

    public String getRequestUri() {
        return this.request.getURI();
    }

    public WritableByteChannel getResponseChannel() {
        return null;
    }

    public OutputStream getResponseStream() {
        try {
            return this.response.getOutputStream();
        }
        catch (IOException ex) {
            return null;
        }
    }

    public String getVersion() {
        return this.request.getMajor() + "." + this.request.getMinor();
    }

    public void writeResponseHead(Response restletResponse) throws IOException {
        this.response.clear();
        for (Parameter header : this.getResponseHeaders()) {
            this.response.add(header.getName(), header.getValue());
        }
        this.response.setCode(this.getStatusCode());
        this.response.setText(this.getReasonPhrase());
        if (restletResponse.getEntity() == null) {
            this.response.setContentLength(0);
        }
    }
}

