/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.xml;

import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import org.geotools.validation.dto.ArgumentDTO;
import org.geotools.validation.dto.PlugInDTO;
import org.geotools.validation.dto.TestDTO;
import org.geotools.validation.dto.TestSuiteDTO;
import org.geotools.validation.xml.ArgHelper;
import org.geotools.validation.xml.WriterUtils;

public class XMLWriter {
    public static void writePlugIn(PlugInDTO dto, Writer w) {
        WriterUtils cw = new WriterUtils(w);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("xmlns", "pluginSchema");
        m.put("xmlns:gml", "http://www.opengis.net/gml");
        m.put("xmlns:ogc", "http://www.opengis.net/ogc");
        m.put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        m.put("xsi:schemaLocation", "pluginSchema /data/capabilities/validate/pluginSchema.xsd");
        try {
            cw.openTag("plugin", m);
            try {
                cw.textTag("name", dto.getName());
                cw.textTag("description", dto.getDescription());
                cw.textTag("class", dto.getClassName());
                Iterator i = dto.getArgs().keySet().iterator();
                while (i.hasNext()) {
                    XMLWriter.writeArgument((ArgumentDTO)dto.getArgs().get(i.next()), w);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            cw.closeTag("plugin");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeTest(TestDTO dto, Writer w) {
        WriterUtils cw = new WriterUtils(w);
        try {
            cw.openTag("test");
            try {
                cw.textTag("name", dto.getName());
                cw.textTag("description", dto.getDescription());
                cw.textTag("plugin", dto.getPlugIn().getName());
                Iterator i = dto.getArgs().keySet().iterator();
                while (i.hasNext()) {
                    XMLWriter.writeArgument((ArgumentDTO)dto.getArgs().get(i.next()), w);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            cw.closeTag("test");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeTestSuite(TestSuiteDTO dto, Writer w) {
        WriterUtils cw = new WriterUtils(w);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("xmlns", "testSuiteSchema");
        m.put("xmlns:gml", "http://www.opengis.net/gml");
        m.put("xmlns:ogc", "http://www.opengis.net/ogc");
        m.put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        m.put("xsi:schemaLocation", "testSuiteSchema /data/capabilities/validate/testSuiteSchema.xsd");
        try {
            cw.openTag("suite", m);
            try {
                cw.textTag("name", dto.getName());
                cw.textTag("description", dto.getDescription());
                Iterator i = dto.getTests().keySet().iterator();
                while (i.hasNext()) {
                    XMLWriter.writeTest((TestDTO)dto.getTests().get(i.next()), w);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            cw.closeTag("suite");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeArgument(ArgumentDTO dto, Writer w) {
        WriterUtils cw = new WriterUtils(w);
        HashMap<String, Boolean> m = new HashMap<String, Boolean>();
        if (dto.isFinal()) {
            m.put("final", new Boolean(true));
        }
        try {
            cw.openTag("argument", m);
            try {
                cw.textTag("name", dto.getName());
                cw.writeln(ArgHelper.getArgumentEncoding(dto.getValue()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            cw.closeTag("argument");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

