/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import java.util.Map;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.spatial.PolygonPolygonAbstractValidation;
import org.opengis.feature.simple.SimpleFeature;

public class PolygonBoundaryCoveredByPolygonValidation
extends PolygonPolygonAbstractValidation {
    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        SimpleFeatureSource polySource = (SimpleFeatureSource)layers.get(this.getPolygonTypeRef());
        SimpleFeatureSource polyrSource = (SimpleFeatureSource)layers.get(this.getRestrictedPolygonTypeRef());
        Object[] polys = polyrSource.getFeatures().toArray();
        Object[] polyRs = polySource.getFeatures().toArray();
        if (!envelope.contains((Envelope)polySource.getBounds())) {
            results.error((SimpleFeature)polys[0], "Poly Feature Source is not contained within the Envelope provided.");
            return false;
        }
        if (!envelope.contains((Envelope)polyrSource.getBounds())) {
            results.error((SimpleFeature)polyRs[0], "Poly Feature Source is not contained within the Envelope provided.");
            return false;
        }
        for (int i = 0; i < polys.length; ++i) {
            SimpleFeature tmp = (SimpleFeature)polys[i];
            Geometry gt = (Geometry)tmp.getDefaultGeometry();
            if (!(gt instanceof Polygon)) continue;
            Polygon ls = (Polygon)gt;
            boolean r = false;
            for (int j = 0; j < polyRs.length && !r; ++j) {
                Polygon pt;
                SimpleFeature tmp2 = (SimpleFeature)polyRs[j];
                Geometry gt2 = (Geometry)tmp2.getDefaultGeometry();
                if (!(gt2 instanceof Polygon) || (pt = (Polygon)gt2).getBoundary().within((Geometry)ls)) continue;
                r = true;
            }
            if (r) continue;
            results.error(tmp, "Polygon does not contained one of the specified polygons.");
            return false;
        }
        return true;
    }
}

