/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.layer;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.web.GWCIconFactory;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayer;

class UnconfiguredCachedLayersProvider
extends GeoServerDataProvider<TileLayer> {
    private static final long serialVersionUID = -8599398086587516574L;
    static final GeoServerDataProvider.Property<TileLayer> TYPE = new GeoServerDataProvider.AbstractProperty<TileLayer>("type"){
        private static final long serialVersionUID = 3215255763580377079L;

        public ResourceReference getPropertyValue(TileLayer item) {
            return GWCIconFactory.getSpecificLayerIcon(item);
        }

        public Comparator<TileLayer> getComparator() {
            return new Comparator<TileLayer>(){

                @Override
                public int compare(TileLayer o1, TileLayer o2) {
                    ResourceReference r1 = this.getPropertyValue(o1);
                    ResourceReference r2 = this.getPropertyValue(o2);
                    return r1.getName().compareTo(r2.getName());
                }
            };
        }
    };
    static final GeoServerDataProvider.Property<TileLayer> NAME = new GeoServerDataProvider.BeanProperty("name", "name");
    static final GeoServerDataProvider.Property<TileLayer> ENABLED = new GeoServerDataProvider.BeanProperty("enabled", "enabled");
    static final List<GeoServerDataProvider.Property<TileLayer>> PROPERTIES = Collections.unmodifiableList(Arrays.asList(TYPE, NAME, ENABLED));

    UnconfiguredCachedLayersProvider() {
    }

    protected List<TileLayer> getItems() {
        GWC gwc = GWC.get();
        final GWCConfig defaults = gwc.getConfig().saneConfig().clone();
        final GridSetBroker gridsets = gwc.getGridSetBroker();
        final Catalog catalog = this.getCatalog();
        defaults.setCacheLayersByDefault(true);
        List<String> unconfiguredLayerIds = this.getUnconfiguredLayers();
        List layers = Lists.transform(unconfiguredLayerIds, (Function)new Function<String, TileLayer>(){

            public TileLayer apply(String input) {
                GeoServerTileLayer geoServerTileLayer;
                LayerInfo layer = catalog.getLayer(input);
                if (layer != null) {
                    geoServerTileLayer = new GeoServerTileLayer(layer, defaults, gridsets);
                } else {
                    LayerGroupInfo layerGroup = catalog.getLayerGroup(input);
                    geoServerTileLayer = new GeoServerTileLayer(layerGroup, defaults, gridsets);
                }
                geoServerTileLayer.getInfo().setEnabled(true);
                return geoServerTileLayer;
            }
        });
        return layers;
    }

    private List<String> getUnconfiguredLayers() {
        Catalog catalog = this.getCatalog();
        LinkedList<String> layerIds = new LinkedList<String>();
        GWC gwc = GWC.get();
        List layers = catalog.getLayers();
        for (LayerInfo l : layers) {
            if (gwc.hasTileLayer((CatalogInfo)l)) continue;
            layerIds.add(l.getId());
        }
        List layerGroups = catalog.getLayerGroups();
        for (LayerGroupInfo lg : layerGroups) {
            if (gwc.hasTileLayer((CatalogInfo)lg)) continue;
            layerIds.add(lg.getId());
        }
        return layerIds;
    }

    protected List<GeoServerDataProvider.Property<TileLayer>> getProperties() {
        return PROPERTIES;
    }

    public IModel<TileLayer> newModel(Object tileLayer) {
        return new UnconfiguredTileLayerDetachableModel(((TileLayer)tileLayer).getName());
    }

    protected Comparator<TileLayer> getComparator(SortParam sort) {
        return super.getComparator(sort);
    }

    private class UnconfiguredTileLayerDetachableModel
    extends LoadableDetachableModel<TileLayer> {
        private static final long serialVersionUID = -8920290470035166218L;
        private String name;

        public UnconfiguredTileLayerDetachableModel(String layerOrGroupName) {
            this.name = layerOrGroupName;
        }

        protected TileLayer load() {
            GWC gwc = GWC.get();
            GWCConfig defaults = gwc.getConfig().saneConfig().clone();
            defaults.setCacheLayersByDefault(true);
            GridSetBroker gridsets = gwc.getGridSetBroker();
            Catalog catalog = UnconfiguredCachedLayersProvider.this.getCatalog();
            LayerInfo layer = catalog.getLayerByName(this.name);
            if (layer != null) {
                return new GeoServerTileLayer(layer, defaults, gridsets);
            }
            LayerGroupInfo layerGroup = catalog.getLayerGroupByName(this.name);
            return new GeoServerTileLayer(layerGroup, defaults, gridsets);
        }
    }
}

