/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.layer;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Check;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.web.layer.GeoServerTileLayerInfoModel;
import org.geoserver.gwc.web.layer.GridSubsetsEditor;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geowebcache.config.XMLGridSubset;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.filter.parameters.FloatParameterFilter;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.parameters.RegexParameterFilter;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayer;

class GeoServerTileLayerEditor
extends FormComponentPanel<GeoServerTileLayerInfo> {
    private static final long serialVersionUID = 7870938096047218989L;
    private final boolean cachedLayerExistedInitially;
    private final GeoServerDialog confirmRemovalDialog;
    private final FormComponent<Boolean> createLayer;
    private final FormComponent<Boolean> enabled;
    private final WebMarkupContainer container;
    private final WebMarkupContainer configs;
    private final FormComponent<Integer> metaTilingX;
    private final FormComponent<Integer> metaTilingY;
    private final FormComponent<Integer> gutter;
    private final CheckGroup<String> cacheFormats;
    private final FormComponent<Boolean> cacheExtraStyles;
    private final FormComponent<Boolean> createTimeParameterFilter;
    private final FormComponent<Boolean> createElevationParameterFilter;
    private final GridSubsetsEditor gridSubsets;
    private final String originalLayerName;
    private IModel<? extends CatalogInfo> layerModel;

    public GeoServerTileLayerEditor(String id, IModel<? extends CatalogInfo> layerModel, IModel<GeoServerTileLayerInfo> tileLayerModel) {
        super(id);
        ResourceModel createTileLayerLabelModel;
        Preconditions.checkArgument((boolean)(tileLayerModel instanceof GeoServerTileLayerInfoModel));
        this.layerModel = layerModel;
        this.setModel(tileLayerModel);
        GWC mediator = GWC.get();
        CatalogInfo info = (CatalogInfo)layerModel.getObject();
        GeoServerTileLayerInfo tileLayerInfo = (GeoServerTileLayerInfo)tileLayerModel.getObject();
        if (info instanceof LayerInfo) {
            createTileLayerLabelModel = new ResourceModel("createTileLayerForLayer");
            ResourceInfo resource = ((LayerInfo)info).getResource();
            resource = (ResourceInfo)ModificationProxy.unwrap((Object)resource);
            this.originalLayerName = resource.getPrefixedName();
        } else if (info instanceof LayerGroupInfo) {
            createTileLayerLabelModel = new ResourceModel("createTileLayerForLayerGroup");
            LayerGroupInfo lgi = (LayerGroupInfo)ModificationProxy.unwrap((Object)((LayerGroupInfo)info));
            this.originalLayerName = GWC.tileLayerName((LayerGroupInfo)lgi);
        } else {
            throw new IllegalArgumentException("Provided model does not target a LayerInfo nor a LayerGroupInfo: " + info);
        }
        TileLayer tileLayer = null;
        if (this.originalLayerName != null) {
            try {
                tileLayer = mediator.getTileLayerByName(this.originalLayerName);
            }
            catch (IllegalArgumentException notFound) {
                // empty catch block
            }
        }
        this.cachedLayerExistedInitially = tileLayer != null;
        Component[] componentArray = new Component[1];
        this.confirmRemovalDialog = new GeoServerDialog("confirmRemovalDialog");
        componentArray[0] = this.confirmRemovalDialog;
        this.add(componentArray);
        this.confirmRemovalDialog.setInitialWidth(360);
        this.confirmRemovalDialog.setInitialHeight(180);
        this.add(new Component[]{new Label("createTileLayerLabel", (IModel)createTileLayerLabelModel)});
        boolean doCreateTileLayer = tileLayerInfo.getId() != null ? true : this.isNew() && mediator.getConfig().isCacheLayersByDefault();
        Component[] componentArray2 = new Component[1];
        this.createLayer = new CheckBox("createTileLayer", (IModel)new Model((Serializable)Boolean.valueOf(doCreateTileLayer)));
        componentArray2[0] = this.createLayer;
        this.add(componentArray2);
        this.createLayer.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("createTileLayer.title"))});
        this.container = new WebMarkupContainer("container");
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        this.configs = new WebMarkupContainer("configs");
        this.configs.setOutputMarkupId(true);
        this.container.add(new Component[]{this.configs});
        Component[] componentArray3 = new Component[1];
        this.enabled = new CheckBox("enabled", (IModel)new PropertyModel((Object)this.getModel(), "enabled"));
        componentArray3[0] = this.enabled;
        this.add(componentArray3);
        this.enabled.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("enabled.title"))});
        this.configs.add(new Component[]{this.enabled});
        List<Integer> metaTilingChoices = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20);
        PropertyModel metaTilingXModel = new PropertyModel((Object)this.getModel(), "metaTilingX");
        this.metaTilingX = new DropDownChoice("metaTilingX", (IModel)metaTilingXModel, metaTilingChoices);
        this.configs.add(new Component[]{this.metaTilingX});
        PropertyModel metaTilingYModel = new PropertyModel((Object)this.getModel(), "metaTilingY");
        this.metaTilingY = new DropDownChoice("metaTilingY", (IModel)metaTilingYModel, metaTilingChoices);
        this.configs.add(new Component[]{this.metaTilingY});
        PropertyModel gutterModel = new PropertyModel((Object)this.getModel(), "gutter");
        List<Integer> gutterChoices = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 15, 20, 50, 100);
        this.gutter = new DropDownChoice("gutter", (IModel)gutterModel, gutterChoices);
        this.configs.add(new Component[]{this.gutter});
        PropertyModel mimeFormatsModel = new PropertyModel((Object)this.getModel(), "mimeFormats");
        this.cacheFormats = new CheckGroup("cacheFormatsGroup", (IModel)mimeFormatsModel);
        this.cacheFormats.setLabel((IModel)new ResourceModel("cacheFormats"));
        this.configs.add(new Component[]{this.cacheFormats});
        List<String> formats = Arrays.asList("image/png", "image/png8", "image/jpeg", "image/gif");
        ListView<String> cacheFormatsList = new ListView<String>("cacheFormats", formats){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<String> item) {
                item.add(new Component[]{new Check("cacheFormatsOption", item.getModel())});
                item.add(new Component[]{new Label("name", item.getModel())});
            }
        };
        cacheFormatsList.setReuseItems(true);
        this.cacheFormats.add(new Component[]{cacheFormatsList});
        this.cacheExtraStyles = this.cacheExtraStylesParameterFilter(info, (IModel<GeoServerTileLayerInfo>)this.getModel());
        this.createTimeParameterFilter = this.createTimeParameterFilter(info, (IModel<GeoServerTileLayerInfo>)this.getModel());
        this.createElevationParameterFilter = this.createElevationParameterFilter(info, (IModel<GeoServerTileLayerInfo>)this.getModel());
        PropertyModel gridSubsetsModel = new PropertyModel((Object)this.getModel(), "gridSubsets");
        this.gridSubsets = new GridSubsetsEditor("cachedGridsets", (IModel<Set<XMLGridSubset>>)gridSubsetsModel);
        this.configs.add(new Component[]{this.gridSubsets});
        this.configs.setVisible(((Boolean)this.createLayer.getModelObject()).booleanValue());
        this.setValidating((Boolean)this.createLayer.getModelObject());
        this.createLayer.add(new IBehavior[]{new OnChangeAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                boolean createTileLayer = (Boolean)GeoServerTileLayerEditor.this.createLayer.getModelObject();
                if (!createTileLayer && GeoServerTileLayerEditor.this.cachedLayerExistedInitially) {
                    GeoServerTileLayerEditor.this.confirmRemovalOfExistingTileLayer(target);
                } else {
                    GeoServerTileLayerEditor.this.updateConfigsVisibility(target);
                }
            }
        }});
    }

    private boolean isNew() {
        GeoServerTileLayerInfoModel model = (GeoServerTileLayerInfoModel)super.getModel();
        return model.isNew();
    }

    public void save() {
        GeoServerTileLayer tileLayer;
        String name;
        GWC gwc = GWC.get();
        CatalogInfo layer = (CatalogInfo)this.layerModel.getObject();
        GeoServerTileLayerInfo tileLayerInfo = (GeoServerTileLayerInfo)this.getModelObject();
        boolean tileLayerExists = gwc.hasTileLayer(layer);
        boolean createLayer = (Boolean)this.createLayer.getModelObject();
        if (!createLayer) {
            if (tileLayerExists) {
                String tileLayerName = tileLayerInfo.getName();
                gwc.removeTileLayers(Arrays.asList(tileLayerName));
            }
            return;
        }
        Preconditions.checkState((layer.getId() != null ? 1 : 0) != 0);
        tileLayerInfo.setId(layer.getId());
        GridSetBroker gridsets = gwc.getGridSetBroker();
        if (layer instanceof LayerGroupInfo) {
            LayerGroupInfo groupInfo = (LayerGroupInfo)layer;
            name = GWC.tileLayerName((LayerGroupInfo)groupInfo);
            tileLayer = new GeoServerTileLayer(groupInfo, gridsets, tileLayerInfo);
        } else {
            LayerInfo layerInfo = (LayerInfo)layer;
            name = GWC.tileLayerName((LayerInfo)layerInfo);
            tileLayer = new GeoServerTileLayer(layerInfo, gridsets, tileLayerInfo);
        }
        tileLayerInfo.setName(name);
        if (tileLayerExists) {
            gwc.save(tileLayer);
        } else {
            gwc.add(tileLayer);
        }
    }

    private FormComponent<Boolean> createElevationParameterFilter(CatalogInfo info, IModel<GeoServerTileLayerInfo> model) {
        LayerInfo layerInfo;
        ResourceInfo resource;
        MetadataMap resourceMetadata;
        DimensionInfo elevationDimension;
        boolean hasElevationDimension = false;
        if (info instanceof LayerInfo && (elevationDimension = (DimensionInfo)(resourceMetadata = (resource = (layerInfo = (LayerInfo)info).getResource()).getMetadata()).get("elevation", DimensionInfo.class)) != null && elevationDimension.isEnabled()) {
            hasElevationDimension = true;
        }
        layerInfo = (GeoServerTileLayerInfo)model.getObject();
        Set parameterFilters = layerInfo.getParameterFilters();
        boolean hasElevationParameterFilter = false;
        if (hasElevationDimension) {
            for (ParameterFilter p : parameterFilters) {
                if (!"ELEVATION".equalsIgnoreCase(p.getKey())) continue;
                hasElevationParameterFilter = true;
                break;
            }
        }
        Label elevationParameterFilterLabel = new Label("elevationParameterFilterLabel", (IModel)new ResourceModel("elevationParameterFilter"));
        this.configs.add(new Component[]{elevationParameterFilterLabel});
        Model elevationParameterFilterModel = new Model((Serializable)Boolean.valueOf(hasElevationParameterFilter));
        CheckBox elevationParameterFilter = new CheckBox("elevationParameterFilter", (IModel)elevationParameterFilterModel);
        elevationParameterFilter.setEnabled(hasElevationDimension);
        if (!hasElevationDimension) {
            elevationParameterFilter.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("elevationParameterFilterDisabled"))});
        }
        this.configs.add(new Component[]{elevationParameterFilter});
        elevationParameterFilterLabel.setVisible(info instanceof LayerInfo);
        elevationParameterFilter.setVisible(info instanceof LayerInfo);
        return elevationParameterFilter;
    }

    private FormComponent<Boolean> createTimeParameterFilter(CatalogInfo info, IModel<GeoServerTileLayerInfo> model) {
        LayerInfo layerInfo;
        ResourceInfo resource;
        MetadataMap resourceMetadata;
        DimensionInfo elevationDimension;
        boolean hasTimeDimension = false;
        if (info instanceof LayerInfo && (elevationDimension = (DimensionInfo)(resourceMetadata = (resource = (layerInfo = (LayerInfo)info).getResource()).getMetadata()).get("time", DimensionInfo.class)) != null && elevationDimension.isEnabled()) {
            hasTimeDimension = true;
        }
        layerInfo = (GeoServerTileLayerInfo)model.getObject();
        Set parameterFilters = layerInfo.getParameterFilters();
        boolean hasTimeParameterFilter = false;
        if (hasTimeDimension) {
            for (ParameterFilter p : parameterFilters) {
                if (!"TIME".equalsIgnoreCase(p.getKey())) continue;
                hasTimeParameterFilter = true;
                break;
            }
        }
        Label timeParameterFilterLabel = new Label("timeParameterFilterLabel", (IModel)new ResourceModel("timeParameterFilter"));
        this.configs.add(new Component[]{timeParameterFilterLabel});
        Model timeParameterFilterModel = new Model((Serializable)Boolean.valueOf(hasTimeParameterFilter));
        CheckBox timeParameterFilter = new CheckBox("timeParameterFilter", (IModel)timeParameterFilterModel);
        timeParameterFilter.setEnabled(hasTimeDimension);
        if (!hasTimeDimension) {
            timeParameterFilter.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("timeParameterFilterDisabled"))});
        }
        this.configs.add(new Component[]{timeParameterFilter});
        timeParameterFilterLabel.setVisible(info instanceof LayerInfo);
        timeParameterFilter.setVisible(info instanceof LayerInfo);
        return timeParameterFilter;
    }

    private FormComponent<Boolean> cacheExtraStylesParameterFilter(CatalogInfo info, IModel<GeoServerTileLayerInfo> model) {
        Label cacheNonDefaultStylesLabel = new Label("cacheNonDefaultStylesLabel", (IModel)new ResourceModel("cacheNonDefaultStyles"));
        this.configs.add(new Component[]{cacheNonDefaultStylesLabel});
        CheckBox cacheExtraStyles = new CheckBox("cacheNonDefaultStyles", (IModel)new PropertyModel(model, "autoCacheStyles"));
        this.configs.add(new Component[]{cacheExtraStyles});
        cacheNonDefaultStylesLabel.setVisible(info instanceof LayerInfo);
        cacheExtraStyles.setVisible(info instanceof LayerInfo);
        return cacheExtraStyles;
    }

    private void updateConfigsVisibility(AjaxRequestTarget target) {
        boolean createTileLayer = (Boolean)this.createLayer.getModelObject();
        this.setValidating(createTileLayer);
        this.configs.setVisible(createTileLayer);
        target.addComponent((Component)this.container);
    }

    private void confirmRemovalOfExistingTileLayer(AjaxRequestTarget origTarget) {
        this.confirmRemovalDialog.setTitle((IModel)new Model((Serializable)((Object)"Confirm removal of cached contents?")));
        this.confirmRemovalDialog.showOkCancel(origTarget, new GeoServerDialog.DialogDelegate(){
            private static final long serialVersionUID = 1L;

            protected Component getContents(String id) {
                GWC gwc = GWC.get();
                Quota usedQuota = gwc.getUsedQuota(GeoServerTileLayerEditor.this.originalLayerName);
                if (usedQuota == null) {
                    usedQuota = new Quota();
                }
                String usedQuotaStr = usedQuota.toNiceString();
                return new Label(id, (IModel)new ParamResourceModel("confirmTileLayerRemoval", (Component)GeoServerTileLayerEditor.this, new Object[]{usedQuotaStr}));
            }

            protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                return true;
            }

            public void onClose(AjaxRequestTarget target) {
                target.addComponent((Component)GeoServerTileLayerEditor.this.createLayer);
                GeoServerTileLayerEditor.this.updateConfigsVisibility(target);
            }

            protected boolean onCancel(AjaxRequestTarget target) {
                GeoServerTileLayerEditor.this.createLayer.setModelObject((Object)Boolean.TRUE);
                boolean closeWindow = true;
                return true;
            }
        });
    }

    private void setValidating(boolean validate) {
        this.gridSubsets.setValidating(validate);
        this.cacheFormats.setRequired(validate);
    }

    protected void convertInput() {
        this.createLayer.processInput();
        boolean createTileLayer = (Boolean)this.createLayer.getModelObject();
        GeoServerTileLayerInfo tileLayerInfo = (GeoServerTileLayerInfo)this.getModelObject();
        if (createTileLayer) {
            this.enabled.processInput();
            this.metaTilingX.processInput();
            this.metaTilingY.processInput();
            this.gutter.processInput();
            this.cacheFormats.processInput();
            this.cacheExtraStyles.processInput();
            this.createTimeParameterFilter.processInput();
            this.createElevationParameterFilter.processInput();
            this.gridSubsets.processInput();
            tileLayerInfo.setId(((CatalogInfo)this.layerModel.getObject()).getId());
            this.updateAcceptAllRegExParameterFilter(tileLayerInfo, "TIME", (Boolean)this.createTimeParameterFilter.getModelObject());
            this.updateAcceptAllFloatParameterFilter(tileLayerInfo, "ELEVATION", (Boolean)this.createElevationParameterFilter.getModelObject());
            this.setConvertedInput(tileLayerInfo);
        } else {
            tileLayerInfo.setId(null);
            this.setConvertedInput(tileLayerInfo);
        }
        this.setModelObject(tileLayerInfo);
    }

    private void updateAcceptAllRegExParameterFilter(GeoServerTileLayerInfo tileLayerInfo, String paramKey, boolean createParam) {
        Set parameterFilters = tileLayerInfo.getParameterFilters();
        Iterator it = parameterFilters.iterator();
        while (it.hasNext()) {
            if (!paramKey.equalsIgnoreCase(((ParameterFilter)it.next()).getKey())) continue;
            it.remove();
            break;
        }
        if (createParam) {
            RegexParameterFilter filter = new RegexParameterFilter();
            filter.setKey(paramKey);
            filter.setDefaultValue("");
            filter.setRegex(".*");
            tileLayerInfo.getParameterFilters().add(filter);
        }
    }

    private void updateAcceptAllFloatParameterFilter(GeoServerTileLayerInfo tileLayerInfo, String paramKey, boolean createParam) {
        Set parameterFilters = tileLayerInfo.getParameterFilters();
        Iterator it = parameterFilters.iterator();
        while (it.hasNext()) {
            if (!paramKey.equalsIgnoreCase(((ParameterFilter)it.next()).getKey())) continue;
            it.remove();
            break;
        }
        if (createParam) {
            FloatParameterFilter filter = new FloatParameterFilter();
            filter.setKey(paramKey);
            filter.setDefaultValue("");
            tileLayerInfo.getParameterFilters().add(filter);
        }
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
    }
}

