/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.layer;

import java.util.HashMap;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.web.layer.LayerCacheOptionsTabPanel;
import org.geoserver.web.data.layergroup.LayerGroupEditPage;
import org.geoserver.web.data.resource.ResourceConfigurationPage;
import org.geoserver.web.wicket.SimpleAjaxLink;
import org.geowebcache.layer.TileLayer;

class ConfigureCachedLayerAjaxLink
extends SimpleAjaxLink<TileLayer> {
    private static final long serialVersionUID = 1L;
    private Class<? extends Page> returnPage;

    public ConfigureCachedLayerAjaxLink(String id, IModel<TileLayer> itemModel, Class<? extends Page> returnPage) {
        super(id, itemModel, (IModel)new PropertyModel(itemModel, "name"));
        this.returnPage = returnPage;
    }

    protected void onClick(AjaxRequestTarget target) {
        TileLayer layer = (TileLayer)this.getModelObject();
        if (!(layer instanceof GeoServerTileLayer)) {
            return;
        }
        GeoServerTileLayer geoserverTileLayer = (GeoServerTileLayer)this.getModelObject();
        LayerInfo layerInfo = geoserverTileLayer.getLayerInfo();
        if (layerInfo != null) {
            ResourceConfigurationPage resourceConfigPage = new ResourceConfigurationPage(layerInfo, false);
            resourceConfigPage.setSelectedTab(LayerCacheOptionsTabPanel.class);
            if (this.returnPage != null) {
                resourceConfigPage.setReturnPage(this.returnPage);
            }
            this.setResponsePage((Page)resourceConfigPage);
        } else {
            LayerGroupInfo layerGroup = geoserverTileLayer.getLayerGroupInfo();
            WorkspaceInfo workspace = layerGroup.getWorkspace();
            String wsName = workspace == null ? null : workspace.getName();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("group", layerGroup.getName());
            params.put("workspace", wsName);
            PageParameters parameters = new PageParameters(params);
            LayerGroupEditPage layerGroupEditPage = new LayerGroupEditPage(parameters);
            if (this.returnPage != null) {
                layerGroupEditPage.setReturnPage(this.returnPage);
            }
            this.setResponsePage((Page)layerGroupEditPage);
        }
    }
}

