/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.gridset;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.web.gridset.GridSetEditPage;
import org.geoserver.gwc.web.gridset.GridSetListTablePanel;
import org.geoserver.gwc.web.gridset.GridSetNewPage;
import org.geoserver.gwc.web.gridset.GridSetTableProvider;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.SimpleBookmarkableLink;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.grid.GridSet;

public class GridSetsPage
extends GeoServerSecuredPage {
    private GridSetsPanel table;
    private SelectionRemovalLink removal;
    private GeoServerDialog dialog;

    public GridSetsPage() {
        GridSetTableProvider provider = new GridSetTableProvider(){

            @Override
            public List<GridSet> getItems() {
                return GWC.get().getGridSetBroker().getGridSets();
            }
        };
        this.table = new GridSetsPanel("table", provider);
        this.table.setOutputMarkupId(true);
        this.add(new Component[]{this.table});
        Component[] componentArray = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray[0] = this.dialog;
        this.add(componentArray);
        this.setHeaderPanel(this.headerPanel());
    }

    protected Component headerPanel() {
        Fragment header = new Fragment("headerPanel", "header", (MarkupContainer)this);
        BookmarkablePageLink newLink = new BookmarkablePageLink("addNew", GridSetNewPage.class);
        newLink.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("addNew.title"))});
        header.add(new Component[]{newLink});
        Component[] componentArray = new Component[1];
        this.removal = new SelectionRemovalLink("removeSelected", this.table, this.dialog);
        componentArray[0] = this.removal;
        header.add(componentArray);
        this.removal.setOutputMarkupId(true);
        this.removal.setEnabled(false);
        this.removal.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("removalLink.title"))});
        return header;
    }

    private class SelectionRemovalLink
    extends AjaxLink<GridSet> {
        GeoServerTablePanel<GridSet> gridsets;
        GeoServerDialog dialog;

        public SelectionRemovalLink(String id, GeoServerTablePanel<GridSet> gridsets, GeoServerDialog dialog) {
            super(id);
            this.gridsets = gridsets;
            this.dialog = dialog;
        }

        public void onClick(AjaxRequestTarget target) {
            List selection = this.gridsets.getSelection();
            if (selection.size() == 0) {
                return;
            }
            final HashSet<String> selectedGridsetIds = new HashSet<String>();
            for (GridSet gset : selection) {
                selectedGridsetIds.add(gset.getName());
            }
            this.dialog.setTitle((IModel)new ParamResourceModel("confirmRemoval", (Component)this, new Object[0]));
            this.dialog.showOkCancel(target, new GeoServerDialog.DialogDelegate(){

                protected Component getContents(String id) {
                    GWC gwc = GWC.get();
                    int count = selectedGridsetIds.size();
                    Quota totalQuota = new Quota();
                    for (String gridsetId : selectedGridsetIds) {
                        Quota usedQuotaByGridSet = gwc.getUsedQuotaByGridSet(gridsetId);
                        if (usedQuotaByGridSet == null) continue;
                        totalQuota.add(usedQuotaByGridSet);
                    }
                    Set affectedLayers = gwc.getLayerNamesForGridSets(selectedGridsetIds);
                    ParamResourceModel confirmModel = new ParamResourceModel("GridSetsPage.confirmGridsetsDelete", (Component)GridSetsPage.this, new Object[]{String.valueOf(count), String.valueOf(affectedLayers.size()), totalQuota.toNiceString()});
                    Label confirmMessage = new Label(id, (IModel)confirmModel);
                    confirmMessage.setEscapeModelStrings(false);
                    return confirmMessage;
                }

                protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                    GWC gwc = GWC.get();
                    try {
                        gwc.removeGridSets(selectedGridsetIds);
                    }
                    catch (IOException e) {
                        SelectionRemovalLink.this.getPage().error((Serializable)((Object)e.getMessage()));
                        LOGGER.log(Level.WARNING, e.getMessage(), e);
                    }
                    SelectionRemovalLink.this.gridsets.clearSelection();
                    return true;
                }

                public void onClose(AjaxRequestTarget target) {
                    if (SelectionRemovalLink.this.gridsets.getSelection().size() == 0) {
                        SelectionRemovalLink.this.setEnabled(false);
                        target.addComponent((Component)SelectionRemovalLink.this);
                        target.addComponent(SelectionRemovalLink.this.gridsets);
                    }
                }
            });
        }
    }

    private class GridSetsPanel
    extends GridSetListTablePanel {
        public GridSetsPanel(String id, GridSetTableProvider provider) {
            super(id, provider, true);
        }

        protected void onSelectionUpdate(AjaxRequestTarget target) {
            GridSetsPage.this.removal.setEnabled(GridSetsPage.this.table.getSelection().size() > 0);
            target.addComponent((Component)GridSetsPage.this.removal);
        }

        @Override
        protected Component nameLink(String id, GridSet gridSet) {
            String gridSetName = gridSet.getName();
            boolean isInternal = GWC.get().getGridSetBroker().getEmbeddedNames().contains(gridSetName);
            SimpleBookmarkableLink link = new SimpleBookmarkableLink(id, GridSetEditPage.class, (IModel)new Model((Serializable)((Object)gridSetName)), new String[]{"gridSet", gridSetName});
            if (isInternal) {
                link.add(new IBehavior[]{new AttributeModifier("style", true, (IModel)new Model((Serializable)((Object)"font-style: italic;")))});
                link.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("nameLink.titleInternalGridSet"))});
            } else {
                link.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("nameLink.title"))});
            }
            return link;
        }

        @Override
        protected Component actionLink(String id, String gridSetName) {
            SimpleBookmarkableLink link = new SimpleBookmarkableLink(id, GridSetNewPage.class, (IModel)new ResourceModel("templateLink"), new String[]{"template", gridSetName});
            link.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("templateLink.title"))});
            return link;
        }
    }
}

