/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.gridset;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.NonSI;
import javax.measure.unit.Unit;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.measure.Units;
import org.geotools.referencing.CRS;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.Grid;
import org.geowebcache.grid.GridSet;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;

class GridSetInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    private CoordinateReferenceSystem crs;
    private ReferencedEnvelope bounds;
    private int tileWidth;
    private int tileHeight;
    private boolean alignTopLeft;
    private List<Grid> levels;
    private double pixelSize;
    private boolean internal;
    private boolean resolutionsPreserved;

    public GridSetInfo() {
        this.internal = false;
        this.levels = new ArrayList<Grid>();
        this.tileWidth = 256;
        this.tileHeight = 256;
        this.pixelSize = 2.8E-4;
        this.resolutionsPreserved = true;
    }

    public GridSetInfo(GridSet gridset, boolean internal) {
        this.internal = internal;
        this.name = gridset.getName();
        this.description = gridset.getDescription();
        String code = "EPSG:" + gridset.getSrs().getNumber();
        boolean longitudeFirst = true;
        try {
            this.crs = CRS.decode((String)code, (boolean)true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        BoundingBox gridsetBounds = gridset.getOriginalExtent();
        double x1 = gridsetBounds.getMinX();
        double x2 = gridsetBounds.getMaxX();
        double y1 = gridsetBounds.getMinY();
        double y2 = gridsetBounds.getMaxY();
        this.bounds = new ReferencedEnvelope(x1, x2, y1, y2, this.crs);
        this.pixelSize = gridset.getPixelSize();
        this.tileWidth = gridset.getTileWidth();
        this.tileHeight = gridset.getTileHeight();
        this.alignTopLeft = gridset.isTopLeftAligned();
        this.resolutionsPreserved = gridset.isResolutionsPreserved();
        Grid[] grids = gridset.getGridLevels();
        this.levels = new ArrayList<Grid>();
        if (grids != null) {
            for (Grid grid : grids) {
                this.levels.add(grid.clone());
            }
        }
    }

    public boolean isResolutionsPreserved() {
        return this.resolutionsPreserved;
    }

    public void setResolutionsPreserved(boolean resolutionsPreserved) {
        this.resolutionsPreserved = resolutionsPreserved;
    }

    public double getPixelSize() {
        return this.pixelSize;
    }

    public void setPixelSize(double pixelSize) {
        this.pixelSize = pixelSize;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public void setInternal(boolean internal) {
        this.internal = internal;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    public void setCrs(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public ReferencedEnvelope getBounds() {
        return this.bounds;
    }

    public void setBounds(ReferencedEnvelope bounds) {
        this.bounds = bounds;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public void setTileWidth(int tileWidth) {
        this.tileWidth = tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public void setTileHeight(int tileHeight) {
        this.tileHeight = tileHeight;
    }

    public boolean isAlignTopLeft() {
        return this.alignTopLeft;
    }

    public void setAlignTopLeft(boolean alignTopLeft) {
        this.alignTopLeft = alignTopLeft;
    }

    public List<Grid> getLevels() {
        return this.levels;
    }

    public void setLevels(List<Grid> levels) {
        this.levels = levels;
    }

    public Double getMetersPerUnit() {
        CoordinateReferenceSystem crs = this.getCrs();
        Double metersPerUnit = this.getMetersPerUnit(crs);
        return metersPerUnit;
    }

    public Double getMetersPerUnit(CoordinateReferenceSystem crs) {
        if (crs == null) {
            return null;
        }
        CoordinateSystemAxis axis = crs.getCoordinateSystem().getAxis(0);
        Unit unit = axis.getUnit();
        return GridSetInfo.metersPerUnit(unit);
    }

    static Double metersPerUnit(Unit<?> unit) {
        double meters;
        Unit degree = NonSI.DEGREE_ANGLE;
        Unit dms = Units.DEGREE_MINUTE_SECOND;
        if (degree.equals(unit)) {
            meters = 111319.49079327358;
        } else {
            Unit metre = Unit.valueOf((CharSequence)"m");
            try {
                meters = unit.getConverterTo(metre).convert(1.0);
            }
            catch (Exception e) {
                UnitConverter converter = unit.getConverterTo(degree);
                double toDegree = converter.convert(1.0);
                meters = toDegree * 111319.49079327358;
            }
        }
        return meters;
    }
}

