/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.diskquota;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.web.diskquota.DiskQuotaConfigPanel;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geotools.image.io.ImageIOExt;
import org.geowebcache.diskquota.DiskQuotaConfig;
import org.geowebcache.diskquota.storage.StorageUnit;

public class DiskQuotaSettingsPage
extends GeoServerSecuredPage {
    public DiskQuotaSettingsPage() {
        DiskQuotaConfig diskQuotaConfig;
        boolean diskQuotaModuleDisabled;
        GWC gwc = this.getGWC();
        boolean bl = diskQuotaModuleDisabled = gwc.getDiskQuotaConfig() == null;
        if (diskQuotaModuleDisabled) {
            diskQuotaConfig = new DiskQuotaConfig();
            diskQuotaConfig.setDefaults();
        } else {
            diskQuotaConfig = gwc.getDiskQuotaConfig().clone();
        }
        final Form form = new Form("form");
        this.add(new Component[]{form});
        Model diskQuotaModel = new Model((Serializable)diskQuotaConfig);
        final DiskQuotaConfigPanel diskQuotaConfigPanel = new DiskQuotaConfigPanel("diskQuotaPanel", (IModel<DiskQuotaConfig>)diskQuotaModel);
        if (diskQuotaModuleDisabled) {
            diskQuotaConfigPanel.setEnabled(false);
            super.warn(new ResourceModel("DiskQuotaSettingsPage.disabledWarning").getObject());
        }
        form.add(new Component[]{diskQuotaConfigPanel});
        form.add(new Component[]{new Button("submit", (IModel)diskQuotaModel){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ IModel val$diskQuotaModel;
            {
                this.val$diskQuotaModel = iModel;
                super(x0);
            }

            public void onSubmit() {
                GWC gwc = DiskQuotaSettingsPage.this.getGWC();
                if (!diskQuotaModuleDisabled) {
                    Double chosenQuota;
                    StorageUnit chosenUnit = diskQuotaConfigPanel.getStorageUnit();
                    String chosenQuotaStr = String.valueOf(diskQuotaConfigPanel.getQuotaValue());
                    try {
                        chosenQuota = Double.valueOf(chosenQuotaStr);
                    }
                    catch (NumberFormatException e) {
                        form.error((Serializable)((Object)(chosenQuotaStr + " is not a valid floating point number")));
                        return;
                    }
                    if (chosenQuota <= 0.0) {
                        form.error((Serializable)((Object)"Quota has to be > 0"));
                        return;
                    }
                    DiskQuotaConfig dqConfig = (DiskQuotaConfig)this.val$diskQuotaModel.getObject();
                    dqConfig.getGlobalQuota().setValue(chosenQuota.doubleValue(), chosenUnit);
                    gwc.saveDiskQuotaConfig(dqConfig);
                }
                DiskQuotaSettingsPage.this.doReturn();
            }
        }});
        form.add(new Component[]{new GeoServerAjaxFormLink("cancel"){
            private static final long serialVersionUID = 1L;

            protected void onClick(AjaxRequestTarget target, Form form) {
                DiskQuotaSettingsPage.this.doReturn();
            }
        }});
        this.checkWarnings();
    }

    private void checkWarnings() {
        Long imageIOFileCachingThreshold = ImageIOExt.getFilesystemThreshold();
        if (null == imageIOFileCachingThreshold || 0L >= imageIOFileCachingThreshold) {
            String warningMsg = new ResourceModel("GWC.ImageIOFileCachingThresholdUnsetWarning").getObject();
            super.warn(warningMsg);
        }
    }

    private GWC getGWC() {
        GWC gwc = (GWC)this.getGeoServerApplication().getBean("gwcFacade");
        return gwc;
    }

    static CheckBox checkbox(String id, IModel<Boolean> model, String titleKey) {
        CheckBox checkBox = new CheckBox(id, model);
        if (null != titleKey) {
            AttributeModifier attributeModifier = new AttributeModifier("title", true, (IModel)new StringResourceModel(titleKey, (Component)null, null));
            checkBox.add(new IBehavior[]{attributeModifier});
        }
        return checkBox;
    }
}

