/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Check;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.web.DefaultGridsetsEditor;

public class CachingOptionsPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private CheckGroup<String> otherFormatsGroup;
    private CheckGroup<String> rasterFormatsGroup;
    private CheckGroup<String> vectorFormatsGroup;

    public CachingOptionsPanel(String id, IModel<GWCConfig> gwcConfigModel) {
        super(id, gwcConfigModel);
        PropertyModel autoCacheLayersModel = new PropertyModel(gwcConfigModel, "cacheLayersByDefault");
        final CheckBox autoCacheLayers = new CheckBox("cacheLayersByDefault", (IModel)autoCacheLayersModel);
        this.add(new Component[]{autoCacheLayers});
        final WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        final WebMarkupContainer configs = new WebMarkupContainer("configs");
        configs.setOutputMarkupId(true);
        configs.setVisible(((Boolean)autoCacheLayersModel.getObject()).booleanValue());
        container.add(new Component[]{configs});
        autoCacheLayers.add(new IBehavior[]{new OnChangeAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                boolean visibleConfigs = (Boolean)autoCacheLayers.getModelObject();
                configs.setVisible(visibleConfigs);
                target.addComponent((Component)container);
            }
        }});
        PropertyModel nonDefaultStylesModel = new PropertyModel(gwcConfigModel, "cacheNonDefaultStyles");
        CheckBox cacheNonDefaultStyles = new CheckBox("cacheNonDefaultStyles", (IModel)nonDefaultStylesModel);
        configs.add(new Component[]{cacheNonDefaultStyles});
        List<Integer> metaTilingChoices = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 16, 17, 18, 19, 20);
        PropertyModel metaTilingXModel = new PropertyModel(gwcConfigModel, "metaTilingX");
        DropDownChoice metaTilingX = new DropDownChoice("metaTilingX", (IModel)metaTilingXModel, metaTilingChoices);
        metaTilingX.setRequired(true);
        configs.add(new Component[]{metaTilingX});
        PropertyModel metaTilingYModel = new PropertyModel(gwcConfigModel, "metaTilingY");
        DropDownChoice metaTilingY = new DropDownChoice("metaTilingY", (IModel)metaTilingYModel, metaTilingChoices);
        metaTilingY.setRequired(true);
        configs.add(new Component[]{metaTilingY});
        PropertyModel gutterModel = new PropertyModel(gwcConfigModel, "gutter");
        List<Integer> gutterChoices = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 15, 20, 50, 100);
        DropDownChoice gutterChoice = new DropDownChoice("gutter", (IModel)gutterModel, gutterChoices);
        configs.add(new Component[]{gutterChoice});
        List<String> formats = Arrays.asList("image/png", "image/png8", "image/jpeg", "image/gif");
        PropertyModel vectorFormatsModel = new PropertyModel(gwcConfigModel, "defaultVectorCacheFormats");
        this.vectorFormatsGroup = new CheckGroup("vectorFormatsGroup", (IModel)vectorFormatsModel);
        configs.add(new Component[]{this.vectorFormatsGroup});
        ListView formatsList = new ListView<String>("vectorFromats", formats){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<String> item) {
                item.add(new Component[]{new Check("vectorFormatsOption", item.getModel())});
                item.add(new Component[]{new Label("name", item.getModel())});
            }
        };
        formatsList.setReuseItems(true);
        this.vectorFormatsGroup.add(new Component[]{formatsList});
        PropertyModel rasterFormatsModel = new PropertyModel(gwcConfigModel, "defaultCoverageCacheFormats");
        this.rasterFormatsGroup = new CheckGroup("rasterFormatsGroup", (IModel)rasterFormatsModel);
        configs.add(new Component[]{this.rasterFormatsGroup});
        formatsList = new ListView<String>("rasterFromats", formats){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<String> item) {
                item.add(new Component[]{new Check("rasterFormatsOption", item.getModel())});
                item.add(new Component[]{new Label("name", item.getModel())});
            }
        };
        formatsList.setReuseItems(true);
        this.rasterFormatsGroup.add(new Component[]{formatsList});
        PropertyModel otherFormatsModel = new PropertyModel(gwcConfigModel, "defaultOtherCacheFormats");
        this.otherFormatsGroup = new CheckGroup("otherFormatsGroup", (IModel)otherFormatsModel);
        configs.add(new Component[]{this.otherFormatsGroup});
        formatsList = new ListView<String>("otherFromats", formats){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<String> item) {
                item.add(new Component[]{new Check("otherFormatsOption", item.getModel())});
                item.add(new Component[]{new Label("name", item.getModel())});
            }
        };
        formatsList.setReuseItems(true);
        this.otherFormatsGroup.add(new Component[]{formatsList});
        PropertyModel cachedGridsetsModel = new PropertyModel(gwcConfigModel, "defaultCachingGridSetIds");
        DefaultGridsetsEditor cachedGridsets = new DefaultGridsetsEditor("cachedGridsets", (IModel<Set<String>>)cachedGridsetsModel);
        configs.add(new Component[]{cachedGridsets});
        cachedGridsets.add((IValidator)new IValidator<Set<String>>((IModel)autoCacheLayersModel){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ IModel val$autoCacheLayersModel;
            {
                this.val$autoCacheLayersModel = iModel;
            }

            public void validate(IValidatable<Set<String>> validatable) {
                boolean validate = (Boolean)this.val$autoCacheLayersModel.getObject();
                if (validate && ((Set)validatable.getValue()).isEmpty()) {
                    ValidationError error = new ValidationError();
                    error.setMessage(new ResourceModel("CachingOptionsPanel.validation.emptyGridsets").getObject());
                    validatable.error((IValidationError)error);
                }
            }
        });
        class FormatsValidator
        implements IValidator<Collection<String>> {
            private static final long serialVersionUID = 1L;
            final /* synthetic */ IModel val$autoCacheLayersModel;

            FormatsValidator() {
                this.val$autoCacheLayersModel = iModel;
            }

            public void validate(IValidatable<Collection<String>> validatable) {
                boolean validate = (Boolean)this.val$autoCacheLayersModel.getObject();
                Collection value = (Collection)validatable.getValue();
                if (validate && value.isEmpty()) {
                    ValidationError error = new ValidationError();
                    error.setMessage(new ResourceModel("CachingOptionsPanel.validation.emptyCacheFormatList").getObject());
                    validatable.error((IValidationError)error);
                }
            }
        }
        FormatsValidator validator = new FormatsValidator();
        this.vectorFormatsGroup.add((IValidator)validator);
        this.rasterFormatsGroup.add((IValidator)validator);
        this.otherFormatsGroup.add((IValidator)validator);
    }
}

