/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.gtopo30;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;

final class GT30Header {
    public static final String BYTEORDER = "BYTEORDER";
    public static final String LAYOUT = "LAYOUT";
    public static final String NROWS = "NROWS";
    public static final String NCOLS = "NCOLS";
    public static final String NBANDS = "NBANDS";
    public static final String NBITS = "NBITS";
    public static final String BANDROWBYTES = "BANDROWBYTES";
    public static final String TOTALROWBYTES = "TOTALROWBYTES";
    public static final String BANDGAPBYTES = "BANDGAPBYTES";
    public static final String NODATA = "NODATA";
    public static final String ULXMAP = "ULXMAP";
    public static final String ULYMAP = "ULYMAP";
    public static final String XDIM = "XDIM";
    public static final String YDIM = "YDIM";
    private static final double STD_CELL_SIZE = 0.00833333333333;
    private Map<String, Object> propertyMap = new HashMap<String, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GT30Header(URL headerURL) throws IOException {
        File header = DataUtilities.urlToFile(headerURL);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(header));
            this.initMap();
            this.parseHeaderFile(reader);
            if (!GT30Header.fullPropertySet(this.propertyMap)) {
                throw new DataSourceException("Needed properties missing in GTOPO30 header file");
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e1) {}
            }
        }
    }

    public Object getProperty(String property) {
        return this.propertyMap.get(property);
    }

    public String getByteOrder() {
        return (String)this.propertyMap.get(BYTEORDER);
    }

    public String getLayout() {
        return (String)this.propertyMap.get(LAYOUT);
    }

    public int getNRows() {
        return (Integer)this.propertyMap.get(NROWS);
    }

    public int getNCols() {
        return (Integer)this.propertyMap.get(NCOLS);
    }

    public int getNBands() {
        return (Integer)this.propertyMap.get(NBANDS);
    }

    public int getNBits() {
        return (Integer)this.propertyMap.get(NBITS);
    }

    public int getBandRowBytes() {
        return (Integer)this.propertyMap.get(BANDROWBYTES);
    }

    public int getRowBytes() {
        return (Integer)this.propertyMap.get(TOTALROWBYTES);
    }

    public int getBandGapBytes() {
        return (Integer)this.propertyMap.get(BANDGAPBYTES);
    }

    public int getNoData() {
        return (Integer)this.propertyMap.get(NODATA);
    }

    public double getULXMap() {
        return (Double)this.propertyMap.get(ULXMAP);
    }

    public double getULYMap() {
        return (Double)this.propertyMap.get(ULYMAP);
    }

    public double getXDim() {
        return (Double)this.propertyMap.get(XDIM);
    }

    public double getYDim() {
        return (Double)this.propertyMap.get(YDIM);
    }

    private void initMap() {
        this.propertyMap.put(BYTEORDER, "M");
        this.propertyMap.put(LAYOUT, "BIL");
        this.propertyMap.put(NROWS, null);
        this.propertyMap.put(NCOLS, null);
        this.propertyMap.put(NBANDS, null);
        this.propertyMap.put(NBITS, null);
        this.propertyMap.put(BANDROWBYTES, null);
        this.propertyMap.put(TOTALROWBYTES, null);
        this.propertyMap.put(BANDGAPBYTES, new Integer(0));
        this.propertyMap.put(NODATA, new Integer(0));
        this.propertyMap.put(ULXMAP, null);
        this.propertyMap.put(ULYMAP, null);
        this.propertyMap.put(XDIM, new Double(0.00833333333333));
        this.propertyMap.put(YDIM, new Double(0.00833333333333));
    }

    private void parseHeaderFile(BufferedReader reader) throws IOException {
        String currLine = reader.readLine();
        while (currLine != null) {
            int firstSpaceIndex = (currLine = currLine.trim()).indexOf(32);
            if (firstSpaceIndex == -1) {
                throw new IOException("Illegal line in GTOPO30 header file");
            }
            String key = currLine.substring(0, firstSpaceIndex).toUpperCase();
            String value = currLine.substring(firstSpaceIndex).trim();
            if (this.propertyMap.containsKey(key)) {
                Class<?> propClass = GT30Header.getPropertyClass(key);
                try {
                    if (propClass == String.class) {
                        this.propertyMap.put(key, value);
                    } else if (propClass == Integer.class) {
                        this.propertyMap.put(key, Integer.valueOf(value));
                    } else if (propClass == Double.class) {
                        this.propertyMap.put(key, Double.valueOf(value));
                    }
                }
                catch (NumberFormatException nfe) {
                    IOException ex = new IOException();
                    ex.initCause(nfe);
                    throw ex;
                }
            }
            currLine = reader.readLine();
        }
        reader.close();
    }

    private static boolean fullPropertySet(Map<String, Object> properties) {
        boolean full = true;
        Collection<Object> values = properties.values();
        Iterator<Object> it = values.iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            full = false;
            break;
        }
        return full;
    }

    private static Class<?> getPropertyClass(String key) {
        Class propClass = null;
        propClass = key.equals(BYTEORDER) || key.equals(LAYOUT) ? String.class : (key.equals(ULXMAP) || key.equals(ULYMAP) || key.equals(XDIM) || key.equals(YDIM) ? Double.class : Integer.class);
        return propClass;
    }
}

